% custombatch.m
% This script does repeated operations on a set of data files.
%
% Please update the relevant fields to account for censored data, etc.

%12/12/2018, SRS - I changed the two instances of 'missing_compiled' to
%'missingCompiled' as I find this easier to read when doing later data
%processing stages.

censoredList = [];
prefix = 'N2_365nm__485nm_2Hz_flicker'
mydate = '_20210330';
suffix = '.mat';
totalFiles = 7;
totalEventTypes = 4;  % Number of event types scored (e.g. pumps and spits)

data_compiled = cell(1, totalEventTypes);
missingCompiled = cell(1, 1);  % This will grow as needed in the loop

cnt = 0;
for i=1:totalFiles
    if (isempty(find(censoredList == i, 1)))
        num = i;
        cnt = cnt + 1;
        if(i < 10)  % Prefix with a 0
            num = strcat('0', num2str(num));
        else
            num = num2str(num);
        end
        newpre = [prefix '_' num '' mydate];
        load([newpre '' suffix]);
        
        for j=1:totalEventTypes
            data_compiled{j}(end+1) = eval([newpre '(' num2str(j) ')']);
        end
        
        % Keep track of missing frames individually
        misstmp = [];
        for j=1:length(missLeft)
            misstmp = [misstmp missLeft(j):missRight(j)];
        end
        missingCompiled{cnt} = misstmp;
    end
end